﻿/*
VERSION:		1.3


USAGE:
#include "functions/swfSprite.as"
newSprite();			// minimum usage		(nothing is seen, but it can be modified later)


#include "functions/swfSprite.as"
var settings = {
	charset				:	"mySprite.swf",
	direction			:	0,				//(base zero)
	isAnimating		:	true
}
mySprite = newSprite( settings, [parent], [instanceName], [depth] );			// maximum usage


COMMANDS:
	setParams( {settings} );			// Changes many settings at once. Only the settings you specify will be altered.
	getParams();									// Retrieves all the current settings.
	getParam( varName );					// Retrieves a specific setting.
	lookAt( sprite1, sprite2 );		// Changes the facing direction of sprite1 to look at sprite2
	isFacing( checkDir );					// Determines whether this sprite is already facing a given direction.
	
EVENTS:		(external functions)
	onLoad
	onLoadError
	
DEPENDANCIES:
	loadImage.as
	nextDepth.as

	
DEPTHS:
	2		image_mc
*/



function newSprite( newSettings, newTarget, newName, newDepth )
{
	// resolve movieClip parameters
	// target
	var newTarget = newTarget || this;
	// name
	var newName = newName || "sprite_"+Math.floor(Math.random()*9999);
	while(newTarget[newName]){
		var newName = "sprite_"+Math.floor(Math.random()*9999);
	}// while:  this movieClip already exists
	// depth
	#include "nextDepth.as"
	var newDepth = (newDepth!=undefined) ? newDepth : nextDepth(newTarget);
	
	
	// create movieClip
	var _this = newTarget.createEmptyMovieClip( newName, newDepth );
	// create image container
	_this.image_mc = _this.createEmptyMovieClip("image_mc", 2);
	
	
	// resolve optional parameters  &  copy settings
	var initSettings = {};
	initSettings.charset = newSettings.charset;
	initSettings.direction = newSettings.direction || 0;
	initSettings.isAnimating = (newSettings.isAnimating!=undefined) ? newSettings.isAnimating : true;
	
	_this.settings = {};
	
	
	// ___________________________________________________________
	// FUNCTIONS
	_this.isLoading = false;
	_this.set_charset = function( fileName )
	{
		_this.isLoading = true;
		#include "loadImage.as"
		var loader = loadImage( fileName, _this.image_mc, "image", 0 );
		_this.settings.charset = fileName;
		
		success = function(){
			// apply other settings
			_this.isLoading = false;
			_this.setParams({	direction:_this.settings.direction,
												isAnimating:_this.settings.isAnimating});
			_this.onLoad();
		}
		loader.onLoadInit = success;
		if(!loader)		// if:  no loader was needed
			success();
		loader.onLoadError = function(){
			_this.isLoading = false;
			_this.onLoadError();
		}
	}// set_charset()
	
	
	
	_this.set_direction = function( newDirection )
	{
		if(newDirection!=undefined)
		{// if:  a direction is specified
			if(newDirection=="right")
				var newDirection = 0;
			if(newDirection=="left")
				var newDirection = 1;
			newDirection %= 2;		// loop:  0 - 1
			_this.settings.direction = newDirection;
			if(!_this.isLoading)
			{// if:  a new file isn't currently loading
				var newScale = (newDirection==0) ? 100 : -100;
				_this.image_mc._xscale = newScale;
			}// if:  a new file isn't currently loading
		}// if:  a direction is specified
	}// set_direction()
	
	
	
	_this.set_isAnimating = function( newAnim )
	{
		if(newAnim!=undefined)
		{// if:  anim setting is specified
			if(!_this.isLoading)
			{// if:  a new file isn't currently loading
				if(newAnim)
					_this.image_mc.image.play();
				else
					_this.image_mc.image.gotoAndStop(1);
			}// if:  a new file isn't currently loading
			
			_this.settings.isAnimating = newAnim;
		}// if:  anim setting is specified
	}// set_isAnimating()
	
	
	
	_this.setParams = function( newSettings )
	{
		// charset
		if( newSettings.charset != undefined
		&&	newSettings.charset != _this.settings.charset){
			_this.set_charset( newSettings.charset );
		}
		// direction
		if( newSettings.direction != undefined){
			_this.set_direction( newSettings.direction );
		}
		// isAnimating
		if( newSettings.isAnimating != undefined){
			_this.set_isAnimating( newSettings.isAnimating );
		}
	}// setParams()
	
	
	
	_this.getParams = function()
	{
		// make a copy of the current settings
		var output = {};
		for(var nam in _this.settings)
			output[nam] = _this.settings[nam];
		// return the copy
		return output;
	}// getParams()
	
	
	
	_this.getParam = function( varName )
	{
		return _this.settings[varName];
	}// getParam()
	
	
	
	_this.lookAt = function( sprite1, sprite2 )
	{
		if(!sprite2){
			var sprite2 = sprite1;
			var sprite1 = _this;
		}
		
		if(sprite2._x > sprite1._x)
			var newDirection = "right";
		else if(sprite2._x < sprite1._x)
			var newDirection = "left";
		
		if(newDirection)
			_this.setParams({direction:newDirection});
	}// lookAt()
	
	
	
	_this.isFacing = function( checkDir )
	{
		if(checkDir=="right")
			var checkDir = 0;
		if(checkDir=="left")
			var checkDir = 1;
		return (_this.settings.direction == checkDir);
	}// isFacing()
	
	
	
	// ___________________________________________________________
	// SETUP
	
	// apply initial settings
	_this.setParams( initSettings );
	
	
	
	// ___________________________________________________________
	// return a reference
	return _this;
}// newSprite()
